#!/bin/sh

BOOTTIME=$( sysctl -a kern.boottime | sed 's/.* sec = //' | sed 's/,.*//' )

timesinceboot() {
	expr $( date +"%s" ) - $BOOTTIME
}

wait_till_seconds_since_boot() {
	while expr `timesinceboot` \< $1 >/dev/null ; do
		echo 'waiting 5s before starting'
		sleep 5s
	done
	echo now `timesinceboot` seconds after boot, good to go
}

# read a String config out of a new-style MIMprefs json.txt file
function readStringConfig() {
	FILE=$1
	KEY=$2
	DEFAULT=$3

	RV=`grep -si "\"$KEY\"" "$FILE" | sed 's#//.*##'| sed 's/.*://' | sed 's/,$//' | sed 's/\"//g' | grep -v ^$ | tail -n 1`
	if [ -z "$RV" ] ; then 
		RV=$DEFAULT
	fi

	echo $RV
}

# read an int config out of a new-style MIMprefs json.txt file
function readIntConfig() {
	FILE=$1
	KEY=$2
	DEFAULT=$3
	LOW=${4:-0}
	HIGH=${5:-100000}

	RV=`grep -si "\"$KEY\"" "$FILE" | sed 's#//.*##'| sed 's/.*://' | sed 's/,$//' | sed 's/[^0-9]*//g' | grep -v ^$ | tail -n 1`
	if [ -z "$RV" ] ; then 
		RV=$DEFAULT
	fi

	(expr $RV \< $LOW > /dev/null) && RV=$LOW
	(expr $RV \> $HIGH > /dev/null) && RV=$HIGH
	echo $RV
}

#XXX: the InstallationCheck also has a copy of this logic
getJavaEightPath() {
	RV=""
	JAVA_PATH="/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java"
	if [ -x "$JAVA_PATH" ]; then
			VERSION=`"$JAVA_PATH" -version 2>&1 | grep "1.8.0"`
			if [ -n "$VERSION" ]; then
					RV="$JAVA_PATH"
			fi
	fi

	if [ -z "$RV" ]; then																																			   
			#either no JRE, or it's not 1.8.  Try and find a JDK...
			if [ -x /usr/libexec/java_home ]; then
					JAVA_PATH="$(/usr/libexec/java_home -F -R -v 1.8)/bin/java"
			fi

			VERSION=`"$JAVA_PATH" -version 2>&1 | grep "1.8.0"`
			if [ -n "$VERSION" ]; then
					RV="$JAVA_PATH"
			fi
	fi

	echo $RV
}

failInvalidJavaVersion() {
	/usr/bin/osascript <<-EOF
		tell application "System Events"
			activate
			display dialog "MIM Requires Java 8 to run"
		end tell
	EOF
}

# requires CONFIG to be defined for the current application's preferences/settings folder
# sets ARCH, RAM, DEFAULTRAM, BIGRAM, MINRAM, SMALLRAM
calculateRam() {
	# use 80% of the system ram as the default max heapsize, as long as it's <12GB
	DEFAULTRAM=$(perl -e '$_ = `sysctl hw.memsize`; s/.* //; my $val = int($_ / 1024 / 1024 * .8 ); print $val < 12288 ? $val : 12288')
	BIGRAM=`readIntConfig "$CONFIG/MachinePrefs.json.txt" "JVM HEAP 64bit" $DEFAULTRAM 200 20480`
	MINRAM=200m

	HAS_64BIT=`sysctl hw.cpu64bit_capable | cut -d ' ' -f 2`
	if [ ""$HAS_64BIT = 1 ] ; then
		ARCH=-d64
		RAM=${BIGRAM}m
		MINRAM=`readIntConfig "$CONFIG/MachinePrefs.json.txt" "JVM MINHEAP 64bit" 1500 200 $BIGRAM`m
	else  #32-bit
		ARCH=-d32
		SMALLRAM=`readIntConfig "$CONFIG/MachinePrefs.json.txt" "JVM HEAP 32bit" 1500 200 2000`m
		RAM=$SMALLRAM
	fi
}
